/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import lombok.Getter;
import lombok.Setter;

/**
 * Represents an XML of Reported Payee without transactions.
 */
@Getter
@Setter
public class XmlReportedPayee {
    private final List<String> otherPaymentMethods = new ArrayList<>();
    private final List<String> otherPspRoles = new ArrayList<>();
    private List<XmlTypeAndValue> names;
    private String country;
    private List<XmlAddress> addresses;
    private List<String> emailAddresses;
    private List<String> webPages;
    private List<XmlTypeAndValue> vatIdentifications;
    private List<XmlCountryTypeAndValue> taxIdentifications;
    private List<XmlCountryTypeAndValue> accountIdentifiers;
    private XmlPsp representative;
    private XmlDocSpec docSpec;
}
